@echo off
REM ---------------------------------------------------------------------------
REM
REM  Copyright (C) Intel Corporation, 2003 - 2006.
REM
REM  File:       subCA_sign.bat
REM
REM  Contents:  batch file which signs the subCA using the demo root CA.
REM
REM ----------------------------------------------------------------------------

REM ############################################################################
REM ###                                                                      ###
REM ### This batch may be called by the Configuration Server program         ###
REM ### in order to generate a demo certificate for the Configuration Server.###
REM ### Normally, you won't need this batch, since you should be using       ###
REM ### Your corporate CA to sign the request.                               ###
REM ### you may customize this script and modify the defaults                ###
REM ### at your own risk.                                                    ###
REM ###                                                                      ###
REM ############################################################################

setlocal

set PATH= %PATH%;../openSSL
set CASUB=.\subCA
set SSLEAY_CONFIG=-config ..\openSSL\openssl_root.cfg


REM ### Sign subCA Certificate ###

openssl ca %SSLEAY_CONFIG% -policy policy_anything -out %CASUB%\subcacert.pem -extensions v3_ca -infiles %CASUB%\certreq.pem < yy.txt

REM ### Convert cert to DER format ###

openssl x509 -in %CASUB%\subcacert.pem -inform PEM -out %CASUB%\subcacert.der -outform DER

endlocal 

IF NOT %CALLER_WAITS_ON_EXIT%=="" EXIT




